/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.GlobalMemoryBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStatusEx
extends AbstractBasicData<MemoryStatusEx> {
    public int dwLength;
    public int dwMemoryLoad;
    public long ullTotalPhys;
    public long ullAvailPhys;
    public long ullTotalPageFile;
    public long ullAvailPageFile;
    public long ullTotalVirtual;
    public long ullAvailVirtual;
    public long ullAvailExtendedVirtual;

    public MemoryStatusEx() {
        super(null);
    }

    @Override
    public MemoryStatusEx getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.dwLength = this.getNextInt();
        this.dwMemoryLoad = this.getNextInt();
        this.ullTotalPhys = this.getNextLong();
        this.ullAvailPhys = this.getNextLong();
        this.ullTotalPageFile = this.getNextLong();
        this.ullAvailPageFile = this.getNextLong();
        this.ullTotalVirtual = this.getNextLong();
        this.ullAvailVirtual = this.getNextLong();
        this.ullAvailExtendedVirtual = this.getNextLong();
        return this;
    }

    @Override
    public int getSizeOf() {
        return MemoryStatusEx.sizeOf();
    }

    public static int sizeOf() {
        return 64;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(new GlobalMemoryBlock(MemoryStatusEx.sizeOf()));
        this.pointer.setIntAt(0, MemoryStatusEx.sizeOf());
        return this.pointer;
    }

    @Override
    public String toString() {
        return "dwLength : " + this.dwLength + "\ndwMemoryLoad : " + this.dwMemoryLoad + "\nullTotalPhys : " + this.ullTotalPhys + "\nullAvailPhys : " + this.ullAvailPhys + "\nullTotalPageFile : " + this.ullTotalPageFile + "\nullAvailPageFile : " + this.ullAvailPageFile + "\nullTotalVirtual : " + this.ullTotalVirtual + "\nullAvailVirtual : " + this.ullAvailVirtual + "\nullAvailExtendedVirtual : " + this.ullAvailExtendedVirtual;
    }
}

