/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PROCESSENTRY32
extends AbstractBasicData<PROCESSENTRY32> {
    public DWORD dwSize = new DWORD(PROCESSENTRY32.sizeOf());
    public DWORD cntUsage = new DWORD(0);
    public DWORD th32ProcessID = new DWORD(0);
    public LONG th32DefaultHeapID = new LONG(0);
    public DWORD th32ModuleID = new DWORD(0);
    public DWORD cntThreads = new DWORD(0);
    public DWORD th32ParentProcessID = new DWORD(0);
    public LONG pcPriClassBase = new LONG(0);
    public DWORD dwFlags = new DWORD(0);
    public String szExeFile = "";

    public PROCESSENTRY32() throws NativeException {
        super(null);
        this.createPointer();
        this.resetPointer();
    }

    public PROCESSENTRY32(int nativeAddress) throws NativeException {
        this();
        this.pointer.setMemory(JNative.getMemory(nativeAddress, PROCESSENTRY32.sizeOf()));
        this.getValueFromPointer();
    }

    public void resetPointer() throws NativeException {
        this.pointer.zeroMemory();
        this.pointer.setIntAt(0, this.dwSize.getValue());
    }

    @Override
    public PROCESSENTRY32 getValue() {
        try {
            this.pointer.zeroMemory();
            int i = -4;
            this.pointer.setIntAt(i += 4, this.dwSize.getValue());
            this.pointer.setIntAt(i += 4, this.cntUsage.getValue());
            this.pointer.setIntAt(i += 4, this.th32ProcessID.getValue());
            this.pointer.setIntAt(i += 4, this.th32DefaultHeapID.getValue());
            this.pointer.setIntAt(i += 4, this.th32ModuleID.getValue());
            this.pointer.setIntAt(i += 4, this.cntThreads.getValue());
            this.pointer.setIntAt(i += 4, this.th32ParentProcessID.getValue());
            this.pointer.setIntAt(i += 4, this.pcPriClassBase.getValue());
            this.pointer.setIntAt(i += 4, this.dwFlags.getValue());
            this.pointer.setStringAt(i += 4, this.szExeFile);
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = Pointer.createPointer(PROCESSENTRY32.sizeOf());
        }
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return PROCESSENTRY32.sizeOf();
    }

    @Override
    public PROCESSENTRY32 getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.dwSize = new DWORD(this.getNextInt());
        this.cntUsage = new DWORD(this.getNextInt());
        this.th32ProcessID = new DWORD(this.getNextInt());
        this.th32DefaultHeapID = new LONG(this.getNextInt());
        this.th32ModuleID = new DWORD(this.getNextInt());
        this.cntThreads = new DWORD(this.getNextInt());
        this.th32ParentProcessID = new DWORD(this.getNextInt());
        this.pcPriClassBase = new LONG(this.getNextInt());
        this.dwFlags = new DWORD(this.getNextInt());
        byte[] b = new byte[256];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.getNextByte();
            if (b[i] == 0) break;
        }
        this.szExeFile = new String(b).trim();
        this.offset = 0;
        return this;
    }

    public static int sizeOf() {
        return 296;
    }
}

