/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.machine.Machine;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLOAT
extends AbstractBasicData<Float> {
    public FLOAT(float value) {
        super(Float.valueOf(value));
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getSizeOf() {
        return FLOAT.sizeOf();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(FLOAT.sizeOf()));
        this.pointer.setFloatAt(0, ((Float)this.mValue).floatValue());
        return this.pointer;
    }

    @Override
    public Float getValueFromPointer() throws NativeException {
        this.mValue = Float.valueOf(this.pointer.getAsFloat(0));
        return (Float)this.mValue;
    }

    public void setValue(float lValue) throws NativeException {
        this.mValue = Float.valueOf(lValue);
        this.pointer.setFloatAt(0, ((Float)this.mValue).floatValue());
    }

    @Override
    public Float getValue() {
        try {
            return this.getValueFromPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int sizeOf() {
        return Machine.SIZE * 4;
    }
}

