/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.ole;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.Kernel32;

public class Oleaut32 {
    public static final String DLL_NAME = "Oleaut32.dll";

    public static final Pointer LoadRegTypeLib(Pointer rguid, int wVerMajor, int wVerMinor, int lcid) throws NativeException, IllegalAccessException {
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
        JNative LoadRegTypeLib = new JNative(DLL_NAME, "LoadRegTypeLib");
        LoadRegTypeLib.setRetVal(Type.INT);
        LoadRegTypeLib.setParameter(0, rguid);
        LoadRegTypeLib.setParameter(1, wVerMajor);
        LoadRegTypeLib.setParameter(2, wVerMinor);
        LoadRegTypeLib.setParameter(3, lcid);
        LoadRegTypeLib.setParameter(4, p);
        LoadRegTypeLib.invoke();
        if (LoadRegTypeLib.getRetValAsInt() == 0) {
            return p;
        }
        return null;
    }

    public static final Pointer SysAllocString(String sz) throws NativeException, IllegalAccessException {
        JNative SysAllocString = new JNative(DLL_NAME, "SysAllocString");
        SysAllocString.setRetVal(Type.INT);
        Pointer p = Kernel32.MultiByteToWideChar(Kernel32.CodePage.CP_UTF8, new DWORD(0), sz, -1, sz.length());
        if (p == null) {
            return null;
        }
        SysAllocString.setParameter(0, p);
        SysAllocString.invoke();
        int ret = SysAllocString.getRetValAsInt();
        if (ret == 0) {
            throw new OutOfMemoryError("Cannot allocate memory in SysAllocString(" + sz + "");
        }
        return new Pointer(new NativeMemoryBlock(ret, sz.length() * 2 + 1)){

            public void dispose() {
                try {
                    Oleaut32.SysFreeString(this);
                }
                catch (NativeException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static final void SysFreeString(Pointer bstr) throws NativeException, IllegalAccessException {
        JNative SysFreeString = new JNative(DLL_NAME, "SysFreeString");
        SysFreeString.setParameter(0, bstr);
        SysFreeString.invoke();
    }
}

