/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected String defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    protected static final int ABORT_AND_CLOSE_ALL_CONNECTIONS = 32;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final String LOCAL_TXN_COMMIT_ON_CLOSE = "LocalTransactionCommitOnClose";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    Vector instancesToRetireQueue = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    protected int connectionClosedCount = 0;
    protected int connectionCreatedCount = 0;
    boolean cacheLocalTxnCommitOnClose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:44_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    OracleImplicitConnectionCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        this.cacheEnabledDS = oracleDataSource;
        this.initializeConnectionCache();
        this.setConnectionCacheProperties(properties);
        this.defaultUserPrePopulateCache(this.cacheInitialLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultUserPrePopulateCache(int n2) throws SQLException {
        if (n2 > 0) {
            String string = this.defaultUser;
            String string2 = this.defaultPassword;
            this.validateUser(string, string2);
            OraclePooledConnection oraclePooledConnection = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                oraclePooledConnection = this.makeOneConnection(string, string2);
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (oraclePooledConnection != null) {
                        --this.cacheSize;
                        this.storeCacheConnection(null, oraclePooledConnection);
                    }
                    continue;
                }
            }
        }
    }

    protected void initializeConnectionCache() throws SQLException {
        this.userMap = new HashMap();
        this.checkedOutConnectionList = new Vector();
        if (this.cacheManager == null) {
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        this.defaultUser = this.cacheEnabledDS.user != null && !this.cacheEnabledDS.user.startsWith("\"") ? this.cacheEnabledDS.user.toLowerCase() : this.cacheEnabledDS.user;
        this.defaultPassword = this.cacheEnabledDS.password;
        if (this.connectionPoolDS == null) {
            this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
            this.cacheEnabledDS.copy(this.connectionPoolDS);
        }
        if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
            this.rand = new Random(0L);
            this.instancesToRetireQueue = new Vector();
            ++this.cacheManager.failoverEnabledCacheCount;
        }
    }

    private void validateUser(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 79);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        Connection connection;
        block20: {
            OraclePooledConnection oraclePooledConnection = null;
            connection = null;
            try {
                if (this.disableConnectionRequest) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 142);
                }
                this.validateUser(string, string2);
                if (!string.startsWith("\"")) {
                    string = string.toLowerCase();
                }
                if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                    oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                }
                if (oraclePooledConnection == null) {
                    this.processConnectionCacheCallback();
                    if (this.cacheSize > 0) {
                        oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                    }
                    if (oraclePooledConnection == null && this.cacheConnectionWaitTimeout > 0) {
                        long l2 = (long)this.cacheConnectionWaitTimeout * 1000L;
                        long l3 = System.currentTimeMillis();
                        long l4 = 0L;
                        do {
                            this.processConnectionWaitTimeout(l2);
                            if (this.cacheSize > 0) {
                                oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                            }
                            l4 = System.currentTimeMillis();
                            l3 = l4;
                        } while (oraclePooledConnection == null && (l2 -= System.currentTimeMillis() - l3) > 0L);
                    }
                }
                if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null || (connection = oraclePooledConnection.getConnection()) == null) break block20;
                if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)connection) != 0) {
                    ((OracleConnection)connection).close(4096);
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 143);
                }
                if (this.cacheAbandonedConnectionTimeout > 0) {
                    ((OracleConnection)connection).setAbandonedTimeoutEnabled(true);
                }
                if (this.cacheTimeToLiveTimeout > 0) {
                    ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    --this.cacheSize;
                    this.checkedOutConnectionList.addElement(oraclePooledConnection);
                }
            }
            catch (SQLException sQLException) {
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (oraclePooledConnection != null) {
                        --this.cacheSize;
                        this.abortConnection(oraclePooledConnection);
                    }
                }
                throw sQLException;
            }
        }
        return connection;
    }

    private OraclePooledConnection getCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = this.retrieveCacheConnection(string, string2, properties);
        if (oraclePooledConnection == null && (oraclePooledConnection = this.makeOneConnection(string, string2)) != null && properties != null && !properties.isEmpty()) {
            this.setUnMatchedAttributes(properties, oraclePooledConnection);
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePooledConnection makeOneConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        boolean bl = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                ++this.pendingCreationRequests;
                bl = true;
            }
        }
        if (bl) {
            try {
                oraclePooledConnection = this.makeCacheConnection(string, string2);
            }
            finally {
                oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (oraclePooledConnection != null) {
                        ++this.connectionCreatedCount;
                    }
                    --this.pendingCreationRequests;
                }
            }
        }
        return oraclePooledConnection;
    }

    protected int getTotalCachedConnections() {
        return this.cacheSize + this.getNumberOfCheckedOutConnections();
    }

    protected int getNumberOfCheckedOutConnections() {
        return this.checkedOutConnectionList.size();
    }

    private synchronized OraclePooledConnection retrieveCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(string, string2));
        if (oracleConnectionCacheEntry != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null) {
                String string3 = this.buildAttrKey(properties);
                Vector vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string3);
                if (vector != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(vector);
                }
                if (oraclePooledConnection == null && this.cacheClosestConnectionMatch) {
                    oraclePooledConnection = this.retrieveClosestConnectionMatch(oracleConnectionCacheEntry.attrConnMap, properties);
                }
                if (oraclePooledConnection == null && oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            }
        }
        if (oraclePooledConnection != null && properties != null && !properties.isEmpty()) {
            this.setUnMatchedAttributes(properties, oraclePooledConnection);
        }
        return oraclePooledConnection;
    }

    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap hashMap, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        Vector vector = null;
        int n2 = properties.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.cacheAttributeWeights != null) {
            n3 = this.getAttributesWeightCount(properties, null);
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                Vector vector2 = (Vector)entry.getValue();
                Object[] objectArray = vector2.toArray();
                int n8 = vector2.size();
                for (int i2 = 0; i2 < n8; ++i2) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[i2];
                    if (oraclePooledConnection.cachedConnectionAttributes == null || oraclePooledConnection.cachedConnectionAttributes.isEmpty() || oraclePooledConnection.cachedConnectionAttributes.size() > n2) continue;
                    if (n3 > 0) {
                        n5 = this.getAttributesWeightCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                        if (n5 <= n4) continue;
                        oraclePooledConnection2 = oraclePooledConnection;
                        n4 = n5;
                        vector = vector2;
                        continue;
                    }
                    n7 = this.getAttributesMatchCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                    if (n7 <= n6) continue;
                    oraclePooledConnection2 = oraclePooledConnection;
                    n6 = n7;
                    vector = vector2;
                }
            }
        }
        if (vector != null) {
            vector.remove(oraclePooledConnection2);
        }
        return oraclePooledConnection2;
    }

    private int getAttributesMatchCount(Properties properties, Properties properties2) throws SQLException {
        int n2 = 0;
        Map.Entry<Object, Object> entry2 = null;
        Object object = null;
        Object object2 = null;
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            object = entry2.getKey();
            object2 = entry2.getValue();
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            ++n2;
        }
        return n2;
    }

    private int getAttributesWeightCount(Properties properties, Properties properties2) throws SQLException {
        Map.Entry<Object, Object> entry2 = null;
        Object object = null;
        Object object2 = null;
        int n2 = 0;
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            object = entry2.getKey();
            object2 = entry2.getValue();
            if (properties2 == null) {
                if (!this.cacheAttributeWeights.containsKey(object)) continue;
                n2 += Integer.parseInt((String)this.cacheAttributeWeights.get(object));
                continue;
            }
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            if (this.cacheAttributeWeights.containsKey(object)) {
                n2 += Integer.parseInt((String)this.cacheAttributeWeights.get(object));
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private void setUnMatchedAttributes(Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection.unMatchedCachedConnAttr == null) {
            oraclePooledConnection.unMatchedCachedConnAttr = new Properties();
        } else {
            oraclePooledConnection.unMatchedCachedConnAttr.clear();
        }
        if (!this.cacheClosestConnectionMatch) {
            oraclePooledConnection.unMatchedCachedConnAttr.putAll((Map<?, ?>)properties);
        } else {
            Properties properties2 = oraclePooledConnection.cachedConnectionAttributes;
            Map.Entry<Object, Object> entry2 = null;
            Object object = null;
            Object object2 = null;
            for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
                object = entry2.getKey();
                object2 = entry2.getValue();
                if (properties2.containsKey(object) || object2.equals(properties2.get(object))) continue;
                oraclePooledConnection.unMatchedCachedConnAttr.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveFromConnectionList(Vector vector) throws SQLException {
        if (vector.isEmpty()) {
            return null;
        }
        OraclePooledConnection oraclePooledConnection = null;
        if (this.fastConnectionFailoverEnabled) {
            if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    int n2 = this.databaseInstancesList.size();
                    OracleDatabaseInstance oracleDatabaseInstance = null;
                    int n3 = 0;
                    boolean[] blArray = new boolean[n2];
                    int n4 = this.dbInstancePercentTotal;
                    block3: for (int i2 = 0; i2 < n2; ++i2) {
                        int n5 = 0;
                        n3 = n4 <= 1 ? 0 : this.rand.nextInt(n4 - 1);
                        for (int i3 = 0; i3 < n2; ++i3) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i3);
                            if (blArray[i3] || oracleDatabaseInstance.flag > 3 || n3 > (n5 += oracleDatabaseInstance.percent)) continue;
                            if (i2 == 0) {
                                ++oracleDatabaseInstance.attemptedConnRequestCount;
                            }
                            if ((oraclePooledConnection = this.selectConnectionFromList(vector, oracleDatabaseInstance)) != null) break block3;
                            n4 -= oracleDatabaseInstance.percent;
                            blArray[i3] = true;
                            continue block3;
                        }
                    }
                }
            }
            int n6 = vector.size();
            int n7 = this.rand.nextInt(n6);
            OraclePooledConnection oraclePooledConnection2 = null;
            for (int i4 = 0; i4 < n6; ++i4) {
                oraclePooledConnection2 = (OraclePooledConnection)vector.get((n7++ + n6) % n6);
                if (oraclePooledConnection2.connectionMarkedDown) continue;
                oraclePooledConnection = oraclePooledConnection2;
                vector.remove(oraclePooledConnection);
                break;
            }
        } else {
            oraclePooledConnection = (OraclePooledConnection)vector.remove(0);
        }
        return oraclePooledConnection;
    }

    private OraclePooledConnection selectConnectionFromList(Vector vector, OracleDatabaseInstance oracleDatabaseInstance) {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            oraclePooledConnection2 = (OraclePooledConnection)vector.get(i2);
            if (oraclePooledConnection2.connectionMarkedDown || oraclePooledConnection2.dataSourceDbUniqNameKey != oracleDatabaseInstance.databaseUniqName || oraclePooledConnection2.dataSourceInstanceNameKey != oracleDatabaseInstance.instanceName) continue;
            oraclePooledConnection = oraclePooledConnection2;
            vector.remove(oraclePooledConnection);
            break;
        }
        return oraclePooledConnection;
    }

    private void removeCacheConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        boolean bl = false;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap);
        if (oracleConnectionCacheEntry != null) {
            String string;
            Vector vector;
            Properties properties = oraclePooledConnection.cachedConnectionAttributes;
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    bl = oracleConnectionCacheEntry.userConnList.removeElement(oraclePooledConnection);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null && (vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string = this.buildAttrKey(properties))) != null) {
                if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
                    oraclePooledConnection.unMatchedCachedConnAttr.clear();
                    oraclePooledConnection.unMatchedCachedConnAttr = null;
                }
                if (oraclePooledConnection.cachedConnectionAttributes != null) {
                    oraclePooledConnection.cachedConnectionAttributes.clear();
                    oraclePooledConnection.cachedConnectionAttributes = null;
                }
                properties = null;
                bl = vector.removeElement(oraclePooledConnection);
            }
        }
        if (bl) {
            --this.cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForEveryCachedConnection(int n2) throws SQLException {
        int n3 = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                for (Map.Entry entry : this.userMap.entrySet()) {
                    OraclePooledConnection oraclePooledConnection;
                    OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue();
                    if (oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        Vector vector = oracleConnectionCacheEntry.userConnList;
                        Object[] objectArray = vector.toArray();
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            oraclePooledConnection = (OraclePooledConnection)objectArray[i2];
                            if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n2)) continue;
                            ++n3;
                        }
                    }
                    if (oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    for (Map.Entry entry2 : oracleConnectionCacheEntry.attrConnMap.entrySet()) {
                        Vector vector = (Vector)entry2.getValue();
                        Object[] objectArray = vector.toArray();
                        for (int i3 = 0; i3 < objectArray.length; ++i3) {
                            oraclePooledConnection = (OraclePooledConnection)objectArray[i3];
                            if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n2)) continue;
                            ++n3;
                        }
                    }
                    if (n2 != 1 && n2 != 32) continue;
                    oracleConnectionCacheEntry.attrConnMap.clear();
                }
                if (n2 == 1 || n2 == 32) {
                    this.userMap.clear();
                    this.cacheSize = 0;
                }
            }
        }
        if (n3 > 0) {
            this.defaultUserPrePopulateCache(n3);
        }
    }

    private boolean performPooledConnectionTask(OraclePooledConnection oraclePooledConnection, int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 2: {
                if (!oraclePooledConnection.connectionMarkedDown) break;
                oraclePooledConnection.needToAbort = true;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 8: {
                if (this.connectionsToRemove <= 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.connectionsToRemove;
                break;
            }
            case 24: {
                if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.retireConnectionsCount;
                if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                bl = true;
                break;
            }
            case 4096: {
                Connection connection = oraclePooledConnection.getLogicalHandle();
                if (connection == null && (connection = oraclePooledConnection.getPhysicalHandle()) == null || this.testDatabaseConnection((OracleConnection)connection) == 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 8192: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 1: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 4: {
                this.processInactivityTimeout(oraclePooledConnection);
                break;
            }
            case 16: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, false);
                break;
            }
            case 18: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
                break;
            }
            case 32: {
                this.abortConnection(oraclePooledConnection);
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
        }
        return bl;
    }

    protected synchronized void doForEveryCheckedOutConnection(int n2) throws SQLException {
        int n3 = this.checkedOutConnectionList.size();
        switch (n2) {
            case 1: {
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(i2), false);
                }
                this.checkedOutConnectionList.removeAllElements();
                break;
            }
            case 24: {
                for (int i3 = 0; i3 < n3 && this.retireConnectionsCount > 0; ++i3) {
                    OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(i3);
                    if (this.instanceToRetire.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) continue;
                    oraclePooledConnection.closeOption = 4096;
                    this.retireConnectionsCount -= 2;
                }
                break;
            }
            case 32: {
                for (int i4 = 0; i4 < n3; ++i4) {
                    OraclePooledConnection oraclePooledConnection = null;
                    oraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(i4);
                    this.abortConnection(oraclePooledConnection);
                    this.closeCheckedOutConnection(oraclePooledConnection, false);
                }
                this.checkedOutConnectionList.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCheckedOutConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        if (oraclePooledConnection != null) {
            OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            try {
                if (!oracleConnection.getAutoCommit() && !oraclePooledConnection.needToAbort) {
                    oracleConnection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                boolean bl2 = oraclePooledConnection.localTxnCommitOnClose;
                try {
                    oraclePooledConnection.localTxnCommitOnClose = false;
                    oracleConnection.cleanupAndClose(true);
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (oraclePooledConnection.localTxnCommitOnClose != bl2) {
                        oraclePooledConnection.localTxnCommitOnClose = bl2;
                    }
                }
            } else {
                this.actualPooledConnectionClose(oraclePooledConnection);
            }
        }
    }

    private synchronized void storeCacheConnection(Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        boolean bl = false;
        if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null) {
            return;
        }
        if (this.cacheInactivityTimeout > 0) {
            oraclePooledConnection.setLastAccessedTime(System.currentTimeMillis());
        }
        if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
            oraclePooledConnection.unMatchedCachedConnAttr.clear();
            oraclePooledConnection.unMatchedCachedConnAttr = null;
        }
        if ((oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap)) != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList == null) {
                    oracleConnectionCacheEntry.userConnList = new Vector();
                }
                bl = oracleConnectionCacheEntry.userConnList.add(oraclePooledConnection);
            } else {
                String string;
                Vector<OraclePooledConnection> vector;
                oraclePooledConnection.cachedConnectionAttributes = properties;
                if (oracleConnectionCacheEntry.attrConnMap == null) {
                    oracleConnectionCacheEntry.attrConnMap = new HashMap();
                }
                if ((vector = (Vector<OraclePooledConnection>)oracleConnectionCacheEntry.attrConnMap.get(string = this.buildAttrKey(properties))) != null) {
                    bl = vector.add(oraclePooledConnection);
                } else {
                    vector = new Vector<OraclePooledConnection>();
                    bl = vector.add(oraclePooledConnection);
                    oracleConnectionCacheEntry.attrConnMap.put(string, vector);
                }
            }
        } else {
            oracleConnectionCacheEntry = new OracleConnectionCacheEntry();
            oraclePooledConnection.addToImplicitCache(this.userMap, oracleConnectionCacheEntry);
            if (properties == null || properties != null && properties.isEmpty()) {
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl = vector.add(oraclePooledConnection);
                oracleConnectionCacheEntry.userConnList = vector;
            } else {
                String string = this.buildAttrKey(properties);
                oraclePooledConnection.cachedConnectionAttributes = properties;
                HashMap hashMap = new HashMap();
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl = vector.add(oraclePooledConnection);
                hashMap.put(string, vector);
                oracleConnectionCacheEntry.attrConnMap = hashMap;
            }
        }
        if (bl) {
            ++this.cacheSize;
        }
        if (this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
    }

    private String buildAttrKey(Properties properties) throws SQLException {
        int n2;
        int n3 = properties.keySet().size();
        Object[] objectArray = properties.keySet().toArray();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            bl = false;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if (((String)objectArray[n2]).compareTo((String)objectArray[n2 + 1]) <= 0) continue;
                bl = true;
                Object object = objectArray[n2];
                objectArray[n2] = objectArray[n2 + 1];
                objectArray[n2 + 1] = object;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(objectArray[n2] + ATTRKEY_DELIM + properties.get(objectArray[n2]));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OraclePooledConnection makeCacheConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(string, string2);
        if (oraclePooledConnection != null) {
            if (this.cacheMaxStatementsLimit > 0) {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
            }
            oraclePooledConnection.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
            oraclePooledConnection.cachedConnectionAttributes = new Properties();
            if (this.fastConnectionFailoverEnabled) {
                this.initFailoverParameters(oraclePooledConnection);
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                ++this.cacheSize;
                if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                    this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                    this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                }
            }
            oraclePooledConnection.localTxnCommitOnClose = this.cacheLocalTxnCommitOnClose;
        }
        return oraclePooledConnection;
    }

    private void setStatementCaching(OraclePooledConnection oraclePooledConnection, int n2, boolean bl) throws SQLException {
        if (n2 > 0) {
            oraclePooledConnection.setStatementCacheSize(n2);
        }
        oraclePooledConnection.setImplicitCachingEnabled(bl);
        oraclePooledConnection.setExplicitCachingEnabled(bl);
    }

    protected synchronized void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)pooledConnection;
        if (oraclePooledConnection != null && oraclePooledConnection.physicalConn != null) {
            if (oraclePooledConnection.localTxnCommitOnClose) {
                oraclePooledConnection.physicalConn.commit();
            }
            this.storeCacheConnection(oraclePooledConnection.cachedConnectionAttributes, oraclePooledConnection);
            this.checkedOutConnectionList.removeElement(oraclePooledConnection);
        }
    }

    protected void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null) {
            this.actualPooledConnectionClose((OraclePooledConnection)pooledConnection);
            if (((OraclePooledConnection)pooledConnection).closeOption == 4096) {
                this.checkedOutConnectionList.removeElement(pooledConnection);
            }
            pooledConnection = null;
            if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                this.defaultUserPrePopulateCache(1);
            }
        }
    }

    protected void refreshCacheConnections(int n2) throws SQLException {
        this.doForEveryCachedConnection(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitializeCacheConnections(Properties properties) throws SQLException {
        int n2 = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            this.defaultUser = this.cacheEnabledDS.user;
            this.defaultPassword = this.cacheEnabledDS.password;
            this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
            this.cleanupTimeoutThread();
            this.doForEveryCheckedOutConnection(1);
            int n3 = this.cacheInitialLimit;
            int n4 = this.cacheMaxLimit;
            int n5 = this.cacheMaxStatementsLimit;
            this.setConnectionCacheProperties(properties);
            if (this.cacheInitialLimit > n3) {
                n2 = this.cacheInitialLimit - n3;
            }
            if (n4 != Integer.MAX_VALUE && this.cacheMaxLimit < n4 && this.cacheSize > this.cacheMaxLimit) {
                this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
                this.doForEveryCachedConnection(8);
                this.connectionsToRemove = 0;
            }
            if (this.cacheMaxStatementsLimit != n5) {
                if (this.cacheMaxStatementsLimit == 0) {
                    this.doForEveryCachedConnection(16);
                } else {
                    this.doForEveryCachedConnection(18);
                }
            }
        }
        if (n2 > 0) {
            this.defaultUserPrePopulateCache(n2);
        }
    }

    protected synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        try {
            if (properties != null) {
                Properties properties2;
                String string = null;
                string = properties.getProperty(MIN_LIMIT_KEY);
                if (string != null && (this.cacheMinLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMinLimit = 0;
                }
                if ((string = properties.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                }
                if (this.cacheMaxLimit < this.cacheMinLimit) {
                    this.cacheMinLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(string)) < 0) {
                    this.cacheInitialLimit = 0;
                }
                if (this.cacheInitialLimit > this.cacheMaxLimit) {
                    this.cacheInitialLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxStatementsLimit = 0;
                }
                if ((properties2 = (Properties)properties.get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                    Map.Entry<Object, Object> entry2 = null;
                    int n2 = 0;
                    Object object = null;
                    for (Map.Entry<Object, Object> entry2 : properties2.entrySet()) {
                        object = entry2.getKey();
                        string = (String)properties2.get(object);
                        if (string == null || (n2 = Integer.parseInt(string)) >= 0) continue;
                        properties2.put(object, DEFAULT_ATTRIBUTE_WEIGHT);
                    }
                    if (this.cacheAttributeWeights == null) {
                        this.cacheAttributeWeights = new Properties();
                    }
                    this.cacheAttributeWeights.putAll((Map<?, ?>)properties2);
                }
                if ((string = properties.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheInactivityTimeout = 0;
                }
                if ((string = properties.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheTimeToLiveTimeout = 0;
                }
                if ((string = properties.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheAbandonedConnectionTimeout = 0;
                }
                if ((string = properties.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                    this.cacheLowerThresholdLimit = Integer.parseInt(string);
                    if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                        this.cacheLowerThresholdLimit = 20;
                    }
                }
                if ((string = properties.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(string)) < 0) {
                    this.cachePropertyCheckInterval = 900;
                }
                if ((string = properties.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                    this.cacheValidateConnection = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                    this.cacheClosestConnectionMatch = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheConnectionWaitTimeout = 0;
                }
                if ((string = properties.getProperty(LOCAL_TXN_COMMIT_ON_CLOSE)) != null) {
                    this.cacheLocalTxnCommitOnClose = string.equalsIgnoreCase("true");
                }
            } else {
                this.cacheMinLimit = 0;
                this.cacheMaxLimit = Integer.MAX_VALUE;
                this.cacheInitialLimit = 0;
                this.cacheMaxStatementsLimit = 0;
                this.cacheAttributeWeights = null;
                this.cacheInactivityTimeout = 0;
                this.cacheTimeToLiveTimeout = 0;
                this.cacheAbandonedConnectionTimeout = 0;
                this.cacheLowerThresholdLimit = 20;
                this.cachePropertyCheckInterval = 900;
                this.cacheClosestConnectionMatch = false;
                this.cacheValidateConnection = false;
                this.cacheConnectionWaitTimeout = 0;
                this.cacheLocalTxnCommitOnClose = false;
            }
            if (this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) {
                if (this.timeoutThread == null) {
                    this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                }
                this.cacheManager.checkAndStartThread(this.timeoutThread);
            }
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 139, "OracleImplicitConnectionCache:setConnectionCacheProperties() - NumberFormatException Occurred :" + numberFormatException.getMessage());
        }
    }

    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
        properties.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
        properties.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
        properties.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
        if (this.cacheAttributeWeights != null) {
            properties.put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
        } else {
            properties.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
        }
        properties.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
        properties.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
        properties.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
        properties.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
        properties.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
        properties.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
        properties.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
        properties.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
        properties.setProperty(LOCAL_TXN_COMMIT_ON_CLOSE, String.valueOf(this.cacheLocalTxnCommitOnClose));
        return properties;
    }

    protected int testDatabaseConnection(OracleConnection oracleConnection) throws SQLException {
        return oracleConnection.pingDatabase();
    }

    protected synchronized void closeConnectionCache(int n2) throws SQLException {
        this.cleanupTimeoutThread();
        this.purgeCacheConnections(true, n2);
        this.connectionPoolDS = null;
        this.cacheEnabledDS = null;
        this.checkedOutConnectionList = null;
        this.userMap = null;
        this.cacheManager = null;
    }

    protected synchronized void disableConnectionCache() throws SQLException {
        this.disableConnectionRequest = true;
    }

    protected synchronized void enableConnectionCache() throws SQLException {
        this.disableConnectionRequest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFailoverParameters(OraclePooledConnection oraclePooledConnection) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Properties properties = ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).getServerSessionInfo();
        string3 = properties.getProperty("INSTANCE_NAME");
        if (string3 != null) {
            string = oraclePooledConnection.dataSourceInstanceNameKey = string3.trim().toLowerCase().intern();
        }
        if ((string3 = properties.getProperty("SERVER_HOST")) != null) {
            oraclePooledConnection.dataSourceHostNameKey = string3.trim().toLowerCase().intern();
        }
        if ((string3 = properties.getProperty("SERVICE_NAME")) != null) {
            this.dataSourceServiceName = string3.trim();
        }
        if ((string3 = properties.getProperty("DATABASE_NAME")) != null) {
            string2 = oraclePooledConnection.dataSourceDbUniqNameKey = string3.trim().toLowerCase().intern();
        }
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        int n2 = this.databaseInstancesList.size();
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            OracleDatabaseInstance oracleDatabaseInstance = null;
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                if (oracleDatabaseInstance.databaseUniqName != string2 || oracleDatabaseInstance.instanceName != string) continue;
                ++oracleDatabaseInstance.numberOfConnectionsCount;
                bl = true;
                break;
            }
            if (!bl) {
                OracleDatabaseInstance oracleDatabaseInstance2 = new OracleDatabaseInstance(string2, string);
                ++oracleDatabaseInstance2.numberOfConnectionsCount;
                this.databaseInstancesList.add(oracleDatabaseInstance2);
            }
        }
    }

    protected void processFailoverEvent(int n2, String string, String string2, String string3, String string4, int n3) {
        if (n2 == 256) {
            if (string4.equalsIgnoreCase("down") || string4.equalsIgnoreCase("not_restarting") || string4.equalsIgnoreCase("restart_failed")) {
                ++this.downEventCount;
                this.markDownLostConnections(true, false, string, string2, string3, string4);
                this.cleanupFailoverConnections(true, false, string, string2, string3, string4);
            } else if (string4.equalsIgnoreCase("up")) {
                if (this.downEventCount > 0) {
                    ++this.upEventCount;
                }
                try {
                    this.processUpEvent(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.isEntireServiceDownProcessed = false;
            }
        } else if (n2 == 512 && string4.equalsIgnoreCase("nodedown")) {
            this.markDownLostConnections(false, true, string, string2, string3, string4);
            this.cleanupFailoverConnections(false, true, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void processUpEvent(int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getTotalCachedConnections();
        boolean bl = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        // MONITORENTER : oracleImplicitConnectionCache
        if (n2 <= 1) {
            n2 = 2;
        }
        if ((n3 = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) <= 0) {
            if (this.getNumberOfDefaultUserConnections() <= 0) {
                // MONITOREXIT : oracleImplicitConnectionCache
                return;
            }
            n4 = (int)((double)this.cacheSize * 0.25);
            bl = true;
        } else {
            n4 = n3 / n2;
            if (n4 + n5 > this.cacheMaxLimit) {
                bl = true;
            }
        }
        if (this.downEventCount == this.upEventCount) {
            this.defaultUserPreFailureSize = 0;
            this.downEventCount = 0;
            this.upEventCount = 0;
        }
        // MONITOREXIT : oracleImplicitConnectionCache
        if (n4 <= 0) return;
        this.loadBalanceConnections(n4, bl);
    }

    private void loadBalanceConnections(int n2, boolean bl) throws SQLException {
        if (bl) {
            this.connectionsToRemove = n2;
            this.doForEveryCachedConnection(8);
            this.connectionsToRemove = 0;
        }
        if (n2 <= 10) {
            try {
                this.defaultUserPrePopulateCache(n2);
            }
            catch (Exception exception) {}
        } else {
            int n3 = (int)((double)n2 * 0.25);
            for (int i2 = 0; i2 < 4; ++i2) {
                try {
                    this.defaultUserPrePopulateCache(n3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private int getNumberOfDefaultUserConnections() {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        int n2 = 0;
        if (this.userMap != null && !this.userMap.isEmpty() && (oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(this.defaultUser, this.defaultPassword))) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
            n2 = oracleConnectionCacheEntry.userConnList.size();
        }
        return n2;
    }

    synchronized void markDownLostConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        if (!this.isEntireServiceDownProcessed) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator iterator = this.userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    OracleConnectionCacheEntry oracleConnectionCacheEntry;
                    boolean bl3 = false;
                    Map.Entry entry = iterator.next();
                    String string5 = null;
                    if (this.defaultUser != null && this.defaultPassword != null) {
                        string5 = this.defaultUser + this.defaultPassword;
                    }
                    if (string5 != null && string5.equalsIgnoreCase((String)entry.getKey())) {
                        bl3 = true;
                    }
                    if ((oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue()) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        boolean bl4 = false;
                        for (Object object : oracleConnectionCacheEntry.userConnList) {
                            if (bl) {
                                bl4 = this.markDownConnectionsForServiceEvent(string, string2, (OraclePooledConnection)object);
                            } else if (bl2) {
                                bl4 = this.markDownConnectionsForHostEvent(string3, (OraclePooledConnection)object);
                            }
                            if (!bl4 || !bl3) continue;
                            ++this.defaultUserPreFailureSize;
                        }
                    }
                    if (oracleConnectionCacheEntry == null || oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    for (Map.Entry entry2 : oracleConnectionCacheEntry.attrConnMap.entrySet()) {
                        Object object;
                        object = ((Vector)entry2.getValue()).iterator();
                        while (object.hasNext()) {
                            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)object.next();
                            if (bl) {
                                this.markDownConnectionsForServiceEvent(string, string2, oraclePooledConnection);
                                continue;
                            }
                            if (!bl2) continue;
                            this.markDownConnectionsForHostEvent(string3, oraclePooledConnection);
                        }
                    }
                }
            }
            if (string == null) {
                this.isEntireServiceDownProcessed = true;
            }
        }
    }

    private boolean markDownConnectionsForServiceEvent(String string, String string2, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if (string == null || string2 == oraclePooledConnection.dataSourceDbUniqNameKey && string == oraclePooledConnection.dataSourceInstanceNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            bl = true;
        }
        return bl;
    }

    private boolean markDownConnectionsForHostEvent(String string, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if (string == oraclePooledConnection.dataSourceHostNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            oraclePooledConnection.needToAbort = true;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanupFailoverConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        int n2;
        OraclePooledConnection oraclePooledConnection = null;
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        int n3 = this.checkedOutConnectionList.size();
        OraclePooledConnection[] oraclePooledConnectionArray = new OraclePooledConnection[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                oraclePooledConnection = (OraclePooledConnection)objectArray[n2];
                if ((!bl || string != null && string != oraclePooledConnection.dataSourceInstanceNameKey || string2 != oraclePooledConnection.dataSourceDbUniqNameKey) && (!bl2 || string3 != oraclePooledConnection.dataSourceHostNameKey)) continue;
                if (oraclePooledConnection.isSameUser(this.defaultUser, this.defaultPassword) && oraclePooledConnection.cachedConnectionAttributes != null && oraclePooledConnection.cachedConnectionAttributes.isEmpty()) {
                    ++this.defaultUserPreFailureSize;
                }
                this.checkedOutConnectionList.removeElement(oraclePooledConnection);
                this.abortConnection(oraclePooledConnection);
                oraclePooledConnection.needToAbort = true;
                oraclePooledConnectionArray[n4++] = oraclePooledConnection;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            try {
                this.closeCheckedOutConnection(oraclePooledConnectionArray[n2], false);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.checkedOutConnectionList.size() < n3 && this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
        try {
            this.doForEveryCachedConnection(2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.databaseInstancesList != null && (n3 = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                objectArray = this.databaseInstancesList.toArray();
                for (int i2 = 0; i2 < n3; ++i2) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)objectArray[i2];
                    if (oracleDatabaseInstance.databaseUniqName != string2 || oracleDatabaseInstance.instanceName != string) continue;
                    if (oracleDatabaseInstance.flag <= 3) {
                        this.dbInstancePercentTotal -= oracleDatabaseInstance.percent;
                    }
                    this.databaseInstancesList.remove(oracleDatabaseInstance);
                }
            }
        }
    }

    void zapRLBInfo() {
        this.databaseInstancesList.clear();
    }

    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection != null) {
            if (oraclePooledConnection.needToAbort) {
                this.abortConnection(oraclePooledConnection);
            }
            this.actualPooledConnectionClose(oraclePooledConnection);
            this.removeCacheConnection(oraclePooledConnection);
        }
    }

    private void abortConnection(OraclePooledConnection oraclePooledConnection) {
        try {
            ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualPooledConnectionClose(OraclePooledConnection oraclePooledConnection) throws SQLException {
        int n2 = 0;
        if (this.databaseInstancesList != null && (n2 = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                for (int i2 = 0; i2 < n2; ++i2) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (oracleDatabaseInstance.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || oracleDatabaseInstance.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) continue;
                    if (oracleDatabaseInstance.numberOfConnectionsCount <= 0) break;
                    --oracleDatabaseInstance.numberOfConnectionsCount;
                    break;
                }
            }
        }
        try {
            ++this.connectionClosedCount;
            oraclePooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int getCacheTimeToLiveTimeout() {
        return this.cacheTimeToLiveTimeout;
    }

    protected int getCacheInactivityTimeout() {
        return this.cacheInactivityTimeout;
    }

    protected int getCachePropertyCheckInterval() {
        return this.cachePropertyCheckInterval;
    }

    protected int getCacheAbandonedTimeout() {
        return this.cacheAbandonedConnectionTimeout;
    }

    private synchronized void processConnectionCacheCallback() throws SQLException {
        float f2 = (float)this.cacheMaxLimit / 100.0f;
        int n2 = (int)((float)this.cacheLowerThresholdLimit * f2);
        this.releaseBasedOnPriority(1024, n2);
        if (this.cacheSize < n2) {
            this.releaseBasedOnPriority(512, n2);
        }
    }

    private void releaseBasedOnPriority(int n2, int n3) throws SQLException {
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        for (int i2 = 0; i2 < objectArray.length && this.cacheSize < n3; ++i2) {
            OracleConnectionCacheCallback oracleConnectionCacheCallback;
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)objectArray[i2];
            OracleConnection oracleConnection = null;
            if (oraclePooledConnection != null) {
                oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            }
            if (oracleConnection == null || (oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj()) == null || oracleConnection.getConnectionCacheCallbackFlag() != 2 && oracleConnection.getConnectionCacheCallbackFlag() != 4 || n2 != oracleConnection.getConnectionReleasePriority()) continue;
            Object object = oracleConnection.getConnectionCacheCallbackPrivObj();
            oracleConnectionCacheCallback.releaseConnection(oracleConnection, object);
        }
    }

    private synchronized void processConnectionWaitTimeout(long l2) throws SQLException {
        try {
            this.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processInactivityTimeout(OraclePooledConnection oraclePooledConnection) throws SQLException {
        long l2 = oraclePooledConnection.getLastAccessedTime();
        long l3 = System.currentTimeMillis();
        if (this.getTotalCachedConnections() > this.cacheMinLimit && l3 - l2 > (long)(this.cacheInactivityTimeout * 1000)) {
            this.closeAndRemovePooledConnection(oraclePooledConnection);
        }
    }

    private void cleanupTimeoutThread() throws SQLException {
        if (this.timeoutThread != null) {
            this.timeoutThread.timeToLive = false;
            if (this.timeoutThread.isSleeping) {
                this.timeoutThread.interrupt();
            }
            this.timeoutThread = null;
        }
    }

    protected void purgeCacheConnections(boolean bl, int n2) {
        try {
            if (bl) {
                this.doForEveryCheckedOutConnection(n2);
            }
            this.doForEveryCachedConnection(n2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDatabaseInstance(String string, String string2, int n2, int n3) {
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            int n4 = this.databaseInstancesList.size();
            boolean bl = false;
            for (int i2 = 0; i2 < n4; ++i2) {
                OracleDatabaseInstance oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                if (oracleDatabaseInstance.databaseUniqName != string || oracleDatabaseInstance.instanceName != string2) continue;
                oracleDatabaseInstance.percent = n2;
                oracleDatabaseInstance.flag = n3;
                bl = true;
                break;
            }
            if (!bl) {
                OracleDatabaseInstance oracleDatabaseInstance = new OracleDatabaseInstance(string, string2);
                oracleDatabaseInstance.percent = n2;
                oracleDatabaseInstance.flag = n3;
                this.databaseInstancesList.add(oracleDatabaseInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() throws SQLException {
        OracleDatabaseInstance oracleDatabaseInstance = null;
        if (this.databaseInstancesList != null) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                int n2;
                int n3 = 0;
                boolean bl = false;
                this.useGoodGroup = false;
                int n4 = this.databaseInstancesList.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n2);
                    if (oracleDatabaseInstance.flag > 3) continue;
                    n3 += oracleDatabaseInstance.percent;
                }
                if (n3 > 0) {
                    this.dbInstancePercentTotal = n3;
                    this.useGoodGroup = true;
                }
                if (n4 > 1) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n2);
                        this.countTotal += oracleDatabaseInstance.attemptedConnRequestCount;
                    }
                    if (this.countTotal > n4 * 1000) {
                        for (n2 = 0; n2 < n4; ++n2) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n2);
                            float f2 = (float)oracleDatabaseInstance.attemptedConnRequestCount / (float)this.countTotal;
                            float f3 = (float)oracleDatabaseInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                            if (!(f3 > f2 * 2.0f)) continue;
                            if ((int)((double)oracleDatabaseInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                this.instancesToRetireQueue.addElement(oracleDatabaseInstance);
                            }
                            bl = true;
                        }
                        if (bl) {
                            for (n2 = 0; n2 < n4; ++n2) {
                                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n2);
                                oracleDatabaseInstance.attemptedConnRequestCount = 0;
                            }
                            bl = false;
                        }
                    }
                }
            }
            if (this.instancesToRetireQueue.size() > 0) {
                if (this.gravitateCacheThread != null) {
                    try {
                        this.gravitateCacheThread.interrupt();
                        this.gravitateCacheThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.gravitateCacheThread = null;
                }
                this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
            }
        }
    }

    protected void gravitateCache() {
        while (this.instancesToRetireQueue.size() > 0) {
            this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireQueue.remove(0);
            this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
            try {
                this.doForEveryCachedConnection(24);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.retireConnectionsCount <= 0) continue;
            try {
                this.doForEveryCheckedOutConnection(24);
            }
            catch (SQLException sQLException) {}
        }
        this.retireConnectionsCount = 0;
        this.instanceToRetire = null;
        this.countTotal = 0;
    }

    protected void cleanupRLBThreads() {
        if (this.gravitateCacheThread != null) {
            try {
                this.gravitateCacheThread.interrupt();
                this.gravitateCacheThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gravitateCacheThread = null;
        }
        if (this.runtimeLoadBalancingThread != null) {
            try {
                this.runtimeLoadBalancingThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runtimeLoadBalancingThread = null;
        }
    }

    Map getStatistics() throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
        hashMap.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
        hashMap.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
        return hashMap;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

