/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg;

import com.sun.webpane.platform.InputMethodClient;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.event.WCInputMethodEvent;
import com.sun.webpane.platform.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public class InputMethodClientImpl
implements InputMethodClient,
InputMethodRequests {
    private final WeakReference<WebView> wvRef;
    private WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView webView, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(webView);
        this.setPage(webPage);
    }

    public final void setPage(WebPage webPage) {
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean bl) {
        WebView webView = (WebView)this.wvRef.get();
        if (webView != null && webView.getScene() != null) {
            webView.getScene().impl_enableInputMethodEvents(bl);
        }
        this.state = bl;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent inputMethodEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (InputMethodTextRun object2 : inputMethodEvent.getComposed()) {
            String i = object2.getText();
            InputMethodHighlight inputMethodHighlight = object2.getHighlight();
            arrayList.add(n);
            arrayList.add(n + i.length());
            arrayList.add(inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED || inputMethodHighlight == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            n += i.length();
            stringBuilder.append(i);
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            arrayList.add(0);
            arrayList.add(n);
            arrayList.add(0);
            n2 = arrayList.size();
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return new WCInputMethodEvent(inputMethodEvent.getCommitted(), stringBuilder.toString(), nArray, inputMethodEvent.getCaretPosition());
    }

    @Override
    public Point2D getTextLocation(int n) {
        int[] nArray = this.webPage.getClientTextLocation(n);
        WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(nArray[0], nArray[1]));
        return new Point2D(wCPoint.getIntX(), wCPoint.getIntY());
    }

    @Override
    public int getLocationOffset(int n, int n2) {
        WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
        return this.webPage.getClientLocationOffset(n - wCPoint.getIntX(), n2 - wCPoint.getIntY());
    }

    @Override
    public void cancelLatestCommittedText() {
    }

    @Override
    public String getSelectedText() {
        return this.webPage.getClientSelectedText();
    }
}

