/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.utils;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static final String LOG_LEVEL = "jnative.com.logLevel";
    private static Map<String, Logger> instances = new HashMap<String, Logger>();
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;
    private static final int TRACE = 5;
    private String identifier;
    private int level;

    private Logger(String identifier, int level) {
        this.identifier = identifier;
        this.level = level;
    }

    public void fatal(Object message) {
        this.log(0, message, null);
    }

    public void error(Object message) {
        this.log(1, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(1, message, t);
    }

    public void warn(Object message) {
        this.log(2, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(2, message, t);
    }

    public void info(Object message) {
        this.log(3, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(3, message, t);
    }

    public void debug(Object message) {
        this.log(4, message, null);
    }

    public void trace(Object message) {
        this.log(5, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int msgLevel, Object message, Throwable t) {
        if (msgLevel > this.level) {
            return;
        }
        PrintStream pw = msgLevel <= 2 ? System.err : System.out;
        PrintStream printStream = pw;
        synchronized (printStream) {
            pw.println("[" + this.identifier + "] - [" + Thread.currentThread().getName() + "] - " + message);
            if (t != null) {
                t.printStackTrace(pw);
            }
        }
    }

    public static synchronized Logger getInstance(String identifier) {
        Logger instance = null;
        instance = instances.get(identifier);
        if (instance == null) {
            instance = System.getProperty(LOG_LEVEL) != null ? new Logger(identifier, Integer.parseInt(System.getProperty(LOG_LEVEL))) : new Logger(identifier, 2);
            instances.put(identifier, instance);
        }
        return instance;
    }
}

