/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.GlobalMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNDCLASS
extends AbstractBasicData<WNDCLASS> {
    public static final int CS_VREDRAW = 1;
    public static final int CS_HREDRAW = 2;
    public static final int CS_KEYCVTWINDOW = 4;
    public static final int CS_DBLCLKS = 8;
    public static final int CS_OWNDC = 32;
    public static final int CS_CLASSDC = 64;
    public static final int CS_PARENTDC = 128;
    public static final int CS_NOKEYCVT = 256;
    public static final int CS_NOCLOSE = 512;
    public static final int CS_SAVEBITS = 2048;
    public static final int CS_BYTEALIGNCLIENT = 4096;
    public static final int CS_BYTEALIGNWINDOW = 8192;
    public static final int CS_GLOBALCLASS = 16384;
    public static final int CS_IME = 65536;
    public static final int CS_DROPSHADOW = 131072;
    private LONG style = new LONG(0);
    private LONG lpfnWndProc = new LONG(0);
    private int cbClsExtra = 0;
    private int cbWndExtra = 0;
    private LONG hInstance = new LONG(0);
    private LONG hIcon = new LONG(0);
    private LONG hCursor = new LONG(0);
    private LONG hbrBackground = new LONG(0);
    private String lpszMenuName = null;
    private String lpszClassName = null;
    private final Pointer lpszMenuNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpszClassNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));

    public WNDCLASS() throws NativeException {
        this((WNDCLASS)null);
    }

    protected WNDCLASS(WNDCLASS lValue) throws NativeException {
        super(lValue);
    }

    private void toPointer() throws NativeException {
        this.offset = 0;
        this.offset += this.pointer.setIntAt(this.offset, this.style.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.lpfnWndProc.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.cbClsExtra);
        this.offset += this.pointer.setIntAt(this.offset, this.cbWndExtra);
        this.offset += this.pointer.setIntAt(this.offset, this.hInstance.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hIcon.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hCursor.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hbrBackground.getValue());
        this.lpszClassNamePointer.zeroMemory();
        if (this.lpszClassName != null) {
            this.lpszClassNamePointer.setStringAt(0, this.lpszClassName);
        }
        this.lpszMenuNamePointer.zeroMemory();
        if (this.lpszMenuName != null) {
            this.lpszMenuNamePointer.setStringAt(0, this.lpszMenuName);
        }
        this.offset += this.pointer.setIntAt(this.offset, this.lpszMenuName == null ? NullPointer.NULL.getPointer() : this.lpszMenuNamePointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpszClassName == null ? NullPointer.NULL.getPointer() : this.lpszClassNamePointer.getPointer());
        this.offset = 0;
    }

    private void fromPointer() throws NativeException {
        this.style = new LONG(this.getNextInt());
        this.lpfnWndProc = new LONG(this.getNextInt());
        this.cbClsExtra = this.getNextInt();
        this.cbWndExtra = this.getNextInt();
        this.hInstance = new LONG(this.getNextInt());
        this.hIcon = new LONG(this.getNextInt());
        this.hCursor = new LONG(this.getNextInt());
        this.hbrBackground = new LONG(this.getNextInt());
        int nextInt = this.getNextInt();
        if (nextInt != 0) {
            this.lpszMenuName = JNative.getMemoryAsString(nextInt, 256);
        }
        if ((nextInt = this.getNextInt()) != 0) {
            this.lpszClassName = JNative.getMemoryAsString(nextInt, 256);
        }
    }

    @Override
    public String toString() {
        String s = "style: " + this.style + "\n";
        s = s + "lpfnWndProc: " + this.lpfnWndProc + "\n";
        s = s + "cbClsExtra: " + this.cbClsExtra + "\n";
        s = s + "cbWndExtra: " + this.cbWndExtra + "\n";
        s = s + "hInstance: " + this.hInstance + "\n";
        s = s + "hIcon: " + this.hIcon + "\n";
        s = s + "hCursor: " + this.hCursor + "\n";
        s = s + "hbrBackground: " + this.hbrBackground + "\n";
        s = s + "lpszMenuName: " + this.lpszMenuName + "\n";
        s = s + "lpszClassName: " + this.lpszClassName + "\n";
        return s;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        }
        this.toPointer();
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 40;
    }

    @Override
    public WNDCLASS getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    public int getCbClsExtra() {
        return this.cbClsExtra;
    }

    public void setCbClsExtra(int cbClsExtra) {
        this.cbClsExtra = cbClsExtra;
    }

    public int getCbWndExtra() {
        return this.cbWndExtra;
    }

    public void setCbWndExtra(int cbWndExtra) {
        this.cbWndExtra = cbWndExtra;
    }

    public LONG getHbrBackground() {
        return this.hbrBackground;
    }

    public void setHbrBackground(LONG hbrBackground) {
        this.hbrBackground = hbrBackground;
    }

    public LONG getHCursor() {
        return this.hCursor;
    }

    public void setHCursor(LONG cursor) {
        this.hCursor = cursor;
    }

    public LONG getHIcon() {
        return this.hIcon;
    }

    public void setHIcon(LONG icon) {
        this.hIcon = icon;
    }

    public LONG getHInstance() {
        return this.hInstance;
    }

    public void setHInstance(LONG instance) {
        this.hInstance = instance;
    }

    public LONG getLpfnWndProc() {
        return this.lpfnWndProc;
    }

    public void setLpfnWndProc(LONG lpfnWndProc) {
        this.lpfnWndProc = lpfnWndProc;
    }

    public String getLpszClassName() {
        return this.lpszClassName;
    }

    public void setLpszClassName(String lpszClassName) {
        this.lpszClassName = lpszClassName;
    }

    public String getLpszMenuName() {
        return this.lpszMenuName;
    }

    public void setLpszMenuName(String lpszMenuName) {
        this.lpszMenuName = lpszMenuName;
    }

    public LONG getStyle() {
        return this.style;
    }

    public void setStyle(LONG style) {
        this.style = style;
    }
}

