/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class PsAPI {
    public static final String DLL_NAME = "PSAPI.DLL";

    public static boolean EnumProcesses(int pProcessIds, DWORD cb, DWORD pBytesReturned) throws NativeException, IllegalAccessException {
        JNative nEnumProcess = new JNative(DLL_NAME, "EnumProcesses");
        nEnumProcess.setRetVal(Type.INT);
        nEnumProcess.setParameter(0, pProcessIds);
        nEnumProcess.setParameter(1, cb.getValue());
        nEnumProcess.setParameter(2, pBytesReturned.getPointer().getPointer());
        nEnumProcess.invoke();
        return nEnumProcess.getRetValAsInt() != 0;
    }

    public static int[] EnumProcess(int maxSizeOfInitialBuffer) throws NativeException, IllegalAccessException {
        if (maxSizeOfInitialBuffer < 4) {
            maxSizeOfInitialBuffer = 4;
        }
        Pointer pProcessIds = new Pointer(MemoryBlockFactory.createMemoryBlock(maxSizeOfInitialBuffer));
        DWORD nReadProcess = new DWORD(0);
        if (!PsAPI.EnumProcesses(pProcessIds.getPointer(), new DWORD(maxSizeOfInitialBuffer), nReadProcess)) {
            return null;
        }
        int sizeNeeded = nReadProcess.getValue();
        if (sizeNeeded >= maxSizeOfInitialBuffer) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, maxSizeOfInitialBuffer + " is to low, will recall with " + (sizeNeeded + 1024));
            return PsAPI.EnumProcess(sizeNeeded + 1024);
        }
        int numProcess = nReadProcess.getValue() / 4;
        int[] process = new int[numProcess];
        for (int i = 0; i < numProcess; ++i) {
            process[i] = pProcessIds.getAsInt(i * 4);
        }
        pProcessIds.dispose();
        return process;
    }

    public static Pointer EnumProcessModules(HANDLE hProcessHandle, int maxSizeOfInitialBuffer) throws NativeException, IllegalAccessException {
        if (maxSizeOfInitialBuffer < 4) {
            maxSizeOfInitialBuffer = 4;
        }
        JNative nEnumProcessModules = new JNative(DLL_NAME, "EnumProcessModules");
        nEnumProcessModules.setRetVal(Type.INT);
        LONG lpcbNeeded = new LONG(0);
        Pointer lphModule = new Pointer(MemoryBlockFactory.createMemoryBlock(maxSizeOfInitialBuffer));
        nEnumProcessModules.setParameter(0, hProcessHandle.getValue());
        nEnumProcessModules.setParameter(1, lphModule);
        nEnumProcessModules.setParameter(2, maxSizeOfInitialBuffer);
        nEnumProcessModules.setParameter(3, lpcbNeeded.getPointer());
        nEnumProcessModules.invoke();
        int sizeNeeded = lpcbNeeded.getValueFromPointer();
        if (nEnumProcessModules.getRetValAsInt() == 0) {
            lphModule.dispose();
            return NullPointer.NULL;
        }
        if (sizeNeeded > maxSizeOfInitialBuffer) {
            lphModule.dispose();
            JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, maxSizeOfInitialBuffer + " is to low, will recall with " + sizeNeeded);
            return PsAPI.EnumProcessModules(hProcessHandle, sizeNeeded);
        }
        return lphModule;
    }

    public static String GetModuleBaseName(HANDLE hProcessHandle, int hModule, int nSize) throws NativeException, IllegalAccessException {
        JNative nGetModuleBaseName = new JNative(DLL_NAME, "GetModuleBaseNameA");
        nGetModuleBaseName.setRetVal(Type.INT);
        Pointer lpBaseName = new Pointer(MemoryBlockFactory.createMemoryBlock(nSize + 1));
        nGetModuleBaseName.setParameter(0, hProcessHandle.getValue());
        nGetModuleBaseName.setParameter(1, hModule);
        nGetModuleBaseName.setParameter(2, lpBaseName);
        nGetModuleBaseName.setParameter(3, nSize);
        nGetModuleBaseName.invoke();
        String ret = null;
        if (nGetModuleBaseName.getRetValAsInt() != 0) {
            ret = lpBaseName.getAsString();
        }
        lpBaseName.dispose();
        return ret;
    }
}

