/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows.hooks;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.constants.winuser.WM;

public class WinEventHook
implements Runnable,
Callback {
    private int startEvent;
    private int endEvent;
    private int myAddress = -1;
    private int hHook;
    private boolean doHook = false;
    private DWORD dwThreadId;
    private int callbackAddress;
    private DWORD dwProcessId;
    private int hModule;
    private UINT flags;
    private Thread thread;
    private volatile Object syncObj = new Object();
    private DWORD hookThreadId;

    public WinEventHook() {
        this(0, null, 0);
    }

    public WinEventHook(int callbackAddress) {
        this(callbackAddress, null, 0);
    }

    public WinEventHook(int callbackAddress, DWORD dwProcessId) {
        this(callbackAddress, dwProcessId, 0);
    }

    public WinEventHook(int callbackAddress, DWORD dwProcessId, int hModule) {
        this(callbackAddress, dwProcessId, hModule, new DWORD(0));
    }

    public WinEventHook(int callbackAddress, DWORD dwProcessId, int hModule, DWORD dwThreadId) {
        this(callbackAddress, dwProcessId, hModule, dwThreadId, new UINT(0));
    }

    public WinEventHook(int callbackAddress, DWORD dwProcessId, int hModule, DWORD dwThreadId, UINT flags) {
        this.dwProcessId = dwProcessId;
        this.hModule = hModule;
        this.callbackAddress = callbackAddress;
        this.dwThreadId = dwThreadId;
        this.flags = flags;
    }

    public int getHookHandle() {
        return this.hHook;
    }

    public void setHModule(int hModule) {
        this.hModule = hModule;
    }

    public void setDwProcessId(DWORD dwProcessId) {
        this.dwProcessId = dwProcessId;
    }

    public void setDwThreadId(DWORD dwThreadId) {
        this.dwThreadId = dwThreadId;
    }

    public void setCallback(int callbackAddr) throws NativeException, IllegalAccessException, InterruptedException {
        this.callbackAddress = callbackAddr;
    }

    public void setFlags(UINT flags) {
        this.flags = flags;
    }

    public boolean isHooked() {
        return this.doHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hook(int startEvent, int endEvent) throws NativeException, IllegalAccessException, InterruptedException {
        if (this.callbackAddress == 0) {
            throw new IllegalArgumentException("Callback address must not be null!");
        }
        if (this.dwProcessId == null) {
            this.dwProcessId = new DWORD(0);
        }
        if (this.dwThreadId == null) {
            this.dwThreadId = new DWORD(0);
        }
        if (this.flags == null) {
            this.flags = new UINT(0);
        }
        if (this.isHooked()) {
            this.unHook();
        }
        this.startEvent = startEvent;
        this.endEvent = endEvent;
        this.doHook = true;
        this.thread = new Thread(this);
        this.thread.start();
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.wait();
        }
        return this.isHooked();
    }

    public synchronized boolean unHook() throws NativeException, IllegalAccessException, InterruptedException {
        if (!this.isHooked()) {
            return false;
        }
        if (this.hookThreadId != null) {
            User32.PostThreadMessage(this.hookThreadId, new UINT(WM.WM_QUIT.getValue()), new WPARAM(0), new LPARAM(0));
        }
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.join();
        }
        this.doHook = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block23: {
            block22: {
                if (!this.isHooked()) {
                    throw new RuntimeException("Do not call run() manually, use hook() method instead!");
                }
                this.hHook = User32.SetWinEventHook(new UINT(this.startEvent), new UINT(this.endEvent), this.hModule, this.callbackAddress, this.dwProcessId, this.dwThreadId, this.flags);
                if (this.hHook != 0) {
                    JNative.getLogger().log("Hook established: hHook = " + this.hHook + ", callbackAddress = " + this.callbackAddress + ", hModule = " + this.hModule + ", dwProcessId = " + this.dwProcessId.getValue());
                    this.hookThreadId = Kernel32.GetCurrentThreadId();
                    Object object = this.syncObj;
                    synchronized (object) {
                        this.syncObj.notify();
                    }
                    MSG msg = new MSG();
                    HWND hwnd = new HWND(0);
                    while (User32.GetMessage(msg, hwnd, 0, 0) > 0) {
                        User32.TranslateMessage(msg);
                        User32.DispatchMessage(msg);
                        msg.getPointer().zeroMemory();
                    }
                    break block22;
                }
                JNative.getLogger().log("Could not establish Hook!");
            }
            Object var4_6 = null;
            this.doHook = false;
            if (this.hHook == 0) break block23;
            try {
                User32.UnhookWinEvent(this.hHook);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (NativeException ex) {
                ex.printStackTrace();
            }
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notify();
        }
        {
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (NativeException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.doHook = false;
            if (this.hHook != 0) {
                try {
                    User32.UnhookWinEvent(this.hHook);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (NativeException ex) {
                    ex.printStackTrace();
                }
            }
            Object object2 = this.syncObj;
            synchronized (object2) {
                this.syncObj.notify();
            }
            throw throwable;
        }
    }

    public int callback(long[] values) {
        return 0;
    }

    public int getCallbackAddress() throws NativeException {
        if (this.myAddress == -1) {
            this.myAddress = JNative.createCallback(7, this);
        }
        return this.myAddress;
    }
}

