/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows.structures;

import java.util.StringTokenizer;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUID
extends AbstractBasicData<GUID> {
    public static final GUID GUID_IO_MEDIA_ARRIVAL = new GUID("A5DCBF10-6530-11D2-901F-00C04FB951ED");
    private DWORD data1 = new DWORD(0);
    private UINT data2 = new UINT(0);
    private UINT data3 = new UINT(0);
    private byte[] data4 = new byte[8];

    @Override
    public String toString() {
        return String.format("{%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x}", this.data1.getValue(), this.data2.getValue(), this.data3.getValue(), this.data4[0], this.data4[1], this.data4[2], this.data4[3], this.data4[4], this.data4[5], this.data4[6], this.data4[7]);
    }

    public GUID() {
        this((GUID)null);
    }

    public GUID(String value) throws NumberFormatException {
        super(null);
        try {
            this.createPointer();
            if (value.matches("\\{[\\-0-9a-fA-F]+\\}")) {
                value = value.substring(1, value.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(value, "-");
            this.data1.setValue((int)Long.parseLong(st.nextToken(), 16));
            this.data2.setValue((short)Integer.parseInt(st.nextToken(), 16));
            this.data3.setValue((short)Integer.parseInt(st.nextToken(), 16));
            String l1 = st.nextToken();
            JNative.getLogger().log(l1);
            String l2 = st.nextToken();
            JNative.getLogger().log(l2);
            this.data4[0] = (byte)Short.parseShort(l1.substring(0, 2), 16);
            this.data4[1] = (byte)Short.parseShort(l1.substring(2), 16);
            for (int i = 0; i < 6; ++i) {
                this.data4[i + 2] = (byte)Short.parseShort(l2.substring(2 * i, 2 * i + 2), 16);
            }
            this.setValue(this);
        }
        catch (NativeException e) {
            throw new RuntimeException(e);
        }
    }

    public GUID(GUID value) {
        super(value);
        try {
            this.createPointer();
            if (value != null) {
                this.data1.setValue(value.data1.getValue());
                this.data2.setValue(value.data2.getValue());
                this.data3.setValue(value.data3.getValue());
                System.arraycopy(value.data4, 0, this.data4, 0, 8);
                this.setValue(this);
            }
        }
        catch (NativeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 16;
    }

    @Override
    public GUID getValueFromPointer() throws NativeException {
        this.data1.setValue(this.getNextInt());
        this.data2.setValue(this.getNextShort());
        this.data3.setValue(this.getNextShort());
        System.arraycopy(this.pointer.getMemory(), this.offset, this.data4, 0, 8);
        return this;
    }

    public void setValue(GUID guid) throws NativeException {
        int offset = 0;
        offset += this.pointer.setIntAt(offset, guid.data1.getValue());
        offset += this.pointer.setShortAt(offset, guid.data2.getValue());
        offset += this.pointer.setShortAt(offset, guid.data3.getValue());
        for (int i = 0; i < 8; ++i) {
            offset += this.pointer.setByteAt(offset, guid.data4[i]);
        }
    }

    public void setValue(byte[] src, int offset) throws NativeException {
        byte[] buffer = this.pointer.getMemory();
        System.arraycopy(src, offset, buffer, 0, 16);
        this.pointer.setMemory(buffer);
        this.getValueFromPointer();
    }
}

