/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.Joinable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

abstract class OracleRowSet
implements Serializable,
Cloneable,
Joinable {
    protected String dataSource;
    protected String dataSourceName;
    protected String url;
    protected String username;
    protected String password;
    protected Map typeMap;
    protected int maxFieldSize;
    protected int maxRows;
    protected int queryTimeout;
    protected int fetchSize;
    protected int transactionIsolation;
    protected boolean escapeProcessing;
    protected String command;
    protected int concurrency;
    protected boolean readOnly;
    protected int fetchDirection;
    protected int rowsetType;
    protected boolean showDeleted;
    protected Vector listener;
    protected RowSetEvent rowsetEvent;
    protected Vector matchColumnIndexes;
    protected Vector matchColumnNames;
    protected boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleRowSet() throws SQLException {
        this.initializeProperties();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.listener = new Vector();
        this.rowsetEvent = new RowSetEvent((RowSet)((Object)this));
        this.isClosed = false;
    }

    protected void initializeProperties() {
        this.command = null;
        this.concurrency = 1007;
        this.dataSource = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.transactionIsolation = 2;
        this.rowsetType = 1005;
        this.typeMap = new HashMap();
        this.username = null;
        this.password = null;
        this.url = null;
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getReadOnly() {
        return this.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getShowDeleted() {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n2) throws SQLException {
        if (n2 != 1007 && n2 != 1008) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.concurrency = n2;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.fetchDirection = n2;
    }

    public void setFetchSize(int n2) throws SQLException {
        this.fetchSize = n2;
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.maxFieldSize = n2;
    }

    public void setMaxRows(int n2) throws SQLException {
        this.maxRows = n2;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.queryTimeout = n2;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        this.transactionIsolation = n2;
    }

    public void setType(int n2) throws SQLException {
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.rowsetType = n2;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        for (int i2 = 0; i2 < this.listener.size(); ++i2) {
            if (!this.listener.elementAt(i2).equals(rowSetListener)) continue;
            return;
        }
        this.listener.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        for (int i2 = 0; i2 < this.listener.size(); ++i2) {
            if (!this.listener.elementAt(i2).equals(rowSetListener)) continue;
            this.listener.remove(i2);
        }
    }

    protected synchronized void notifyCursorMoved() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).cursorMoved(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).rowChanged(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).rowSetChanged(this.rowsetEvent);
            }
        }
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        int[] nArray;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.matchColumnNames.size() > 0) {
            String[] stringArray = this.getMatchColumnNames();
            int n2 = stringArray.length;
            nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.findColumn(stringArray[i2]);
            }
        } else {
            int n3 = this.matchColumnIndexes.size();
            nArray = new int[n3];
            int n4 = -1;
            for (int i3 = 0; i3 < n3; ++i3) {
                try {
                    n4 = (Integer)this.matchColumnIndexes.get(i3);
                }
                catch (Exception exception) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n4 <= 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nArray[i3] = n4;
            }
        }
        return nArray;
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        this.checkIfMatchColumnNamesSet();
        int n2 = this.matchColumnNames.size();
        String[] stringArray = new String[n2];
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                string = (String)this.matchColumnNames.get(i2);
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 337);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string == null || string.equals("")) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 337);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            stringArray[i2] = string;
        }
        return stringArray;
    }

    @Override
    public void setMatchColumn(int n2) throws SQLException {
        if (n2 <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, n2);
        }
        catch (Exception exception) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 338);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (nArray == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                this.matchColumnIndexes.add(i2, nArray[i2]);
                continue;
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 338);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        if (string == null || string.equals("")) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, string.trim());
        }
        catch (Exception exception) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 339);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                this.matchColumnNames.add(i2, stringArray[i2].trim());
                continue;
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 339);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public void unsetMatchColumn(int n2) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (n2 <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = -1;
        try {
            n3 = (Integer)this.matchColumnIndexes.get(0);
        }
        catch (Exception exception) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 != n2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 340);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (nArray == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                n2 = (Integer)this.matchColumnIndexes.get(i2);
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == nArray[i2]) continue;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 340);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (string == null || string.equals("")) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = null;
        try {
            string2 = (String)this.matchColumnNames.get(0);
        }
        catch (Exception exception) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!string2.equals(string.trim())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 341);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (stringArray == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                string = (String)this.matchColumnNames.get(i2);
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string.equals(stringArray[i2])) continue;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 341);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    protected void checkIfMatchColumnIndexesSet() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    protected void checkIfMatchColumnNamesSet() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    abstract String getTableName() throws SQLException;

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

