/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourceUtil {
    public static Resource[] loadResources(String locationPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:" + locationPattern);
            return resources;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Resource loadResourcesOne(String locationPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:" + locationPattern);
            if (resources != null && resources.length > 0) {
                return resources[0];
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static List<InputStream> loadResourcesAsInputStream(String locationPattern) {
        Resource[] resources;
        ArrayList<InputStream> xmlInputStreamList = new ArrayList<InputStream>();
        Resource[] resourceArray = resources = ResourceUtil.loadResources(locationPattern);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            try {
                xmlInputStreamList.add(resource.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return xmlInputStreamList;
    }

    public static InputStream loadResourcesOneAsInputStream(String locationPattern) {
        Resource resource = ResourceUtil.loadResourcesOne(locationPattern);
        if (resource != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                System.out.println(e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Resource getResource(String location) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource resource = resolver.getResource(location);
        return resource;
    }
}

